# Simply Spud

(StepMania 5/Project Outfox theme, formerly "Simply Potato")

[![Simply Spud v1.0 Trailer](https://imgur.com/8nUFos1.png)](https://www.youtube.com/watch?v=-I_RcxNFP84)

*([Click here to view the trailer for Simply Spud v1.0!](https://www.youtube.com/watch?v=-I_RcxNFP84 "Simply Spud v1.0 Trailer"))*

---

## About

Simply Spud is a StepMania/Outfox theme that focues on:
 * A balance of simplicity and stylistic flair
 * An intuitive menu design for casual players, with useful features for pro players

A fork of Simply Love SM5, it adds more of flair and polish while sharing some of the original's simplistic charm and most of its core features for pro players. Other modifications were made to reduce stumbling points for new players


## Screenshots
[![Simply Spud v1.0 Screenshots](https://i.imgur.com/xA4Cl5p.png)](https://imgur.com/a/qTixYbk "Simply Spud v1.0 Screenshots")

*([Click here to view a short screenshot gallery](https://imgur.com/a/qTixYbk))*

---

## Installation

This theme is designed to be used with any of the following:

* [Project Outfox (recommended)](https://projectoutfox.com/downloads)
* [StepMania 5.1 beta](https://github.com/stepmania/stepmania/releases/tag/v5.1.0-b2)
* [StepMania 5.0.12](https://github.com/stepmania/stepmania/releases/tag/v5.0.12)


1. Install one of the supported StepMania/Outfox versions, above
2. Either [grab the latest release](https://github.com/48productions/Simply-Potato-SM5/releases), or click the green "Code" button at the top right of this page, then "Download ZIP" for the most recent version.

3. Unzip the theme into the *Themes* folder (StepMania 5.x) or the *Appearance/Themes* folder (Outfox).

4. Launch the game and switch to this theme. How to do this depends on your current theme, but is generally in the *Settings* menu under the *Apperance* category.


Though still supported, Simply Spud is not frequently tested with non-Outfox game versions.

---

## Changes from Simply Love SM5

Current major changes:
  * Supports Outfox (formerly StepMania 5.3, for improved performance and new features)
  * Overhauled aesthetics - nearly every screen has more animation and stylistic flair
  * Overhauled play experience to reduce stumbling points for new players
   * [Improved style selection](https://i.imgur.com/9VP89ps.png) - Casual and ITG mode are now Beginner and Pro mode. FA+/StomperZ are still available in Pro mode.
   * [Overhauled Casual Mode](https://i.imgur.com/UNKqByU.png) - now features a cover-flow style song list and improved difficulty selection
   * [Reworked Pro Mode] - More open and visually stylized song selection, with two-part song, then difficulty selection
  * An optional potato-inspired visual style to go along with the other styles (hearts, arrows, thonk, etc)

Other useful features and tools for public cab operators:
  * Configurable song rating scales/group descriptions on the music wheel, can color song titles based on rating scale
  * Default songs for profileless players now affect *all* play modes
  * Can optionally auto-fail players at 30/51 miss combo (for players that walk away from the cab mid-song)
  * A News feature, to show configurable images in the attract mode loop and to players with memory cards
  * "Modfile" groups - Gives modfiles colored titles, and shows a warning to new players.
  * Tweaks to the attract loop, including demo play (set the songs to play by adding a course named "Simply-Potato-SM5")
  * Cab lighting test in the service menu
  * More easter eggs and bug fixes!
  
Do note that while the original Simply Love theme was translated into several languages, Simply Spud (at the moment at least) only has English translations for the new lines of text.

---

## Special Thanks
  * Thanks to skogaby for letting us know that Simply Spud is a much better name than Simply Potato
  * Thanks to quietly-turning, hurtpiggypig, and everyone else who helped with the original Simply Love themes for SM5 and SM3.95, directly or indirectly. Your help helped create the *de facto* Stepmania theme for multiple generations of dance game players, and no other theme I've seen has compared to the amount of polish and *love* that was put into the original themes.


---

## FAQ

#### Why are my high scores ranking out of order?
You need to set `PercentageScoring=1` in your Preferences.ini file.  Please note that you must quit StepMania before opening and editing Preferences.ini.

Your existing scores will remain ranked out of order, but all scores going forward after making this change will be ranked correctly.

#### Where is my Preferences.ini file?
See the [Manually Changing Preferences](https://github.com/stepmania/stepmania/wiki/Manually-Changing-Preferences) page on StepMania's GitHub Wiki.

#### How can I get more songs to show up in Casual Mode?
Please refer to the [Casual Mode README](./Other/CasualMode-README.md).

#### Why spuds?
Why not? 🥔

